<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SaaSServiceManagement;

class UnitKind extends \Google\Collection
{
  protected $collection_key = 'outputVariableMappings';
  /**
   * @var string[]
   */
  public $annotations;
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $defaultRelease;
  protected $dependenciesType = Dependency::class;
  protected $dependenciesDataType = 'array';
  /**
   * @var string
   */
  public $etag;
  protected $inputVariableMappingsType = VariableMapping::class;
  protected $inputVariableMappingsDataType = 'array';
  /**
   * @var string[]
   */
  public $labels;
  /**
   * @var string
   */
  public $name;
  protected $outputVariableMappingsType = VariableMapping::class;
  protected $outputVariableMappingsDataType = 'array';
  /**
   * @var string
   */
  public $saas;
  /**
   * @var string
   */
  public $uid;
  /**
   * @var string
   */
  public $updateTime;

  /**
   * @param string[]
   */
  public function setAnnotations($annotations)
  {
    $this->annotations = $annotations;
  }
  /**
   * @return string[]
   */
  public function getAnnotations()
  {
    return $this->annotations;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setDefaultRelease($defaultRelease)
  {
    $this->defaultRelease = $defaultRelease;
  }
  /**
   * @return string
   */
  public function getDefaultRelease()
  {
    return $this->defaultRelease;
  }
  /**
   * @param Dependency[]
   */
  public function setDependencies($dependencies)
  {
    $this->dependencies = $dependencies;
  }
  /**
   * @return Dependency[]
   */
  public function getDependencies()
  {
    return $this->dependencies;
  }
  /**
   * @param string
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * @param VariableMapping[]
   */
  public function setInputVariableMappings($inputVariableMappings)
  {
    $this->inputVariableMappings = $inputVariableMappings;
  }
  /**
   * @return VariableMapping[]
   */
  public function getInputVariableMappings()
  {
    return $this->inputVariableMappings;
  }
  /**
   * @param string[]
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param VariableMapping[]
   */
  public function setOutputVariableMappings($outputVariableMappings)
  {
    $this->outputVariableMappings = $outputVariableMappings;
  }
  /**
   * @return VariableMapping[]
   */
  public function getOutputVariableMappings()
  {
    return $this->outputVariableMappings;
  }
  /**
   * @param string
   */
  public function setSaas($saas)
  {
    $this->saas = $saas;
  }
  /**
   * @return string
   */
  public function getSaas()
  {
    return $this->saas;
  }
  /**
   * @param string
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UnitKind::class, 'Google_Service_SaaSServiceManagement_UnitKind');
